<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
            $table->string('patient_id')->unique();
            $table->string('title')->nullable();
            $table->string('first_name');
            $table->string('last_name');
            $table->date('date_of_birth')->nullable();
            $table->enum('gender', ['Male', 'Female', 'Other'])->nullable();
            $table->string('identity_number')->nullable();
            $table->string('phone_area_code')->nullable();
            $table->string('phone_number');
            $table->string('email')->nullable();
            $table->enum('payment_mode', ['Cash Payment', 'Medical Aid Payment'])->default('Cash Payment');
            $table->string('medical_aid_number')->nullable();
            $table->string('main_member')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('patients');
    }
};

